varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D 	vignette;
uniform float		vignetteLum;

vec4 			color;

void main()
{
	color=texture2D(tex,texcoord);
	
	// vignette
	vec4 vignetteColor=texture2D(vignette, texcoord);
	color=mix(color,vignetteColor,clamp(vignetteLum,0.0,1.0)*(1.0-vignetteColor.a));
	
	gl_FragColor.xyz = max(vec3(0.0,0.0,0.0),color.xyz);
}
